<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.1"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://www.w3.org/1999/xhtml"
    xmlns:d="http://dynamicnodes.mastersign.de/description">

  <xsl:output method="xml"/>

  <xsl:template match="/">
    <html>
      <xsl:choose>
        <xsl:when test="/d:node/@lang">
          <xsl:attribute name="lang">
            <xsl:value-of select="/d:node/@lang"/>
          </xsl:attribute>
          <xsl:attribute name="xml:lang">
            <xsl:value-of select="/d:node/@lang"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="lang">de</xsl:attribute>
          <xsl:attribute name="xml:lang">de</xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="/d:node"/>
    </html>
  </xsl:template>

  <xsl:template match="d:node">
    <head>
      <meta http-equiv="content-type" content="application/xhtml+xml; charset=UTF-8" />
      <meta http-equiv="X-UA-Compatible" content="IE=9" />
      <title>
        <xsl:value-of select ="d:group"/>
        -
        <xsl:value-of select="d:caption"/>
      </title>
      <link type="text/css" rel="Stylesheet" href="../../../design/help.css"/>
    </head>
    <body>
      <div id="head">
        <img alt="DynamicNodes" src="../../../design/help_head.gif" />
      </div>
      <div id="content">
        <h1>
          Knotentyp &quot;<xsl:value-of select="d:group"/> : <xsl:value-of select="d:caption"/>&quot;
        </h1>

        <xsl:apply-templates mode="index" select="." />
        <xsl:apply-templates mode="summary" select="." />
        <xsl:apply-templates select="d:helpText"/>
        <xsl:apply-templates mode="ports" select="." />
        <xsl:apply-templates select="d:commands"/>
        <xsl:apply-templates select="d:customArea"/>

      </div>
    </body>
  </xsl:template>

  <xsl:template match="d:node" mode="index">
    <div class="index">
      <h2>Inhalt</h2>
      <ul>
        <li>
          <a href="#summary">Zusammenfassung</a>
        </li>
        <li>
          <a href="#help_text">Beschreibung</a>
        </li>
        <li>
          <a href="#ports">Anschlüsse</a>
        </li>
        <xsl:if test="d:commands">
          <li>
            <a href="#commands">Befehle</a>
          </li>
        </xsl:if>
        <xsl:if test="d:customArea">
          <li>
            <a href="#custom_area">Grafische Darstellung</a>
          </li>
        </xsl:if>
      </ul>
    </div>
  </xsl:template>

  <xsl:template match="d:node" mode="summary">
    <div id="summary">
      <h2>Zusammenfassung</h2>
      <table cellspacing="0" cellpadding="0" border="0">
        <thead>
          <tr>
            <td>Eigenschaften</td>
            <td>Wert</td>
          </tr>
        </thead>
        <tr>
          <td>Gruppe</td>
          <td>
            <xsl:value-of select="d:group"/>
          </td>
        </tr>
        <tr>
          <td>Name</td>
          <td>
            <xsl:value-of select="d:caption"/>
          </td>
        </tr>
        <xsl:if test="d:description">
          <tr>
            <td>Beschreibung</td>
            <td>
              <xsl:value-of select="d:description"/>
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td>Typ</td>
          <td>
            <span class="code">
              <xsl:value-of select="@type"/>
            </span>
          </td>
        </tr>
        <tr>
          <td>Assembly</td>
          <td>
            <span class="code">
              <xsl:value-of select="@assembly"/>
            </span>
          </td>
        </tr>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="d:helpText">
    <div id="help_text">
      <h2>Beschreibung</h2>
      <p>
        <xsl:apply-templates/>
      </p>
    </div>
  </xsl:template>

  <xsl:template match="d:node" mode="ports">
    <div id="ports">
      <h2>Anschlüsse</h2>
      <xsl:apply-templates select="d:inPorts"/>
      <xsl:apply-templates select="d:outPorts"/>
    </div>
  </xsl:template>

  <xsl:template match="d:inPorts">
    <h3>Eingänge</h3>
    <xsl:choose>
      <xsl:when test="count(d:port) &gt; 0">
        <table cellspacing="0" cellpadding="0" border="0">
          <thead>
            <tr>
              <td>Name</td>
              <td>Typen</td>
              <td>Beschreibung</td>
            </tr>
          </thead>
          <xsl:apply-templates select="d:port"/>
        </table>
      </xsl:when>
      <xsl:otherwise>
        <p>Keine Eingänge vorhanden.</p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="d:outPorts">
    <h3>Ausgänge</h3>
    <xsl:choose>
      <xsl:when test="count(d:port) &gt; 0">
        <table cellspacing="0" cellpadding="0" border="0">
          <thead>
            <tr>
              <td>Name</td>
              <td>Typen</td>
              <td>Beschreibung</td>
            </tr>
          </thead>
          <xsl:apply-templates select="d:port"/>
        </table>
      </xsl:when>
      <xsl:otherwise>
        <p>Keine Ausgänge vorhanden.</p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="d:port">
    <tr>
      <td style="white-space: nowrap;">
        <xsl:value-of select="@name"/>
      </td>
      <td style="white-space: nowrap;">
        <xsl:apply-templates select="d:type" />
      </td>
      <td>
        <xsl:apply-templates select="d:description" />
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="d:type">
    <div class="code">
      <xsl:value-of select="." />
    </div>
  </xsl:template>

  <xsl:template match="d:commands">
    <div id="commands">
      <h2>Befehle</h2>
      <table cellspacing="0" cellpadding="0" border="0">
        <thead>
          <tr>
            <td>Name</td>
            <td>Code</td>
            <td>Beschreibung</td>
          </tr>
        </thead>
        <xsl:if test="d:defaultCommand">
          <tr>
            <td>Standardbefehl</td>
            <td></td>
            <td>
              <xsl:value-of select="d:defaultCommand"/>
            </td>
          </tr>
        </xsl:if>
        <xsl:apply-templates select="d:command"/>
      </table>
    </div>
  </xsl:template>

  <xsl:template match="d:command">
    <tr>
      <td style="white-space: nowrap;">
        <xsl:value-of select="@caption"/>
      </td>
      <td style="white-space: nowrap;">
        <span class="code">
          <xsl:value-of select="@code"/>
        </span>
      </td>
      <td>
        <xsl:apply-templates/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="d:customArea">
    <div id="custom_area">
      <h2>Grafische Darstellung</h2>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="d:p">
    <p>
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="d:info">
    <div class="info">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="d:comment">
    <div class="comment">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="d:reference">
    <xsl:choose>
      <xsl:when test="@type='wikipedia'">
        <div class="reference wikipedia">
          <a target="_blank" title="Wikipedia Referenz">
            <xsl:attribute name="href">
              <xsl:text>http://</xsl:text>
              <xsl:value-of select="@lang"/>
              <xsl:text>.wikipedia.org/wiki/</xsl:text>
              <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:apply-templates />
          </a>
        </div>
      </xsl:when>
      <xsl:when test="@type='msdn'">
        <div class="reference msdn">
          <a target="_blank" title="MSDN Library Referenz">
            <xsl:attribute name="href">
              <xsl:text>http://msdn.microsoft.com/</xsl:text>
              <xsl:if test="@lang">
                <xsl:value-of select="@lang"/>
                <xsl:text>/</xsl:text>
              </xsl:if>
              <xsl:text>library/</xsl:text>
              <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:apply-templates />
          </a>
        </div>
      </xsl:when>
      <xsl:when test="@type='url'">
        <div class="reference url">
          <a target="_blank" title="Allgemeiner Hyperlink">
            <xsl:attribute name="href">
              <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:apply-templates />
          </a>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="reference unknown">
          Unbekannter Referenztyp (<xsl:value-of select="@type" />):
          <xsl:apply-templates />
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="d:b">
    <b>
      <xsl:apply-templates/>
    </b>
  </xsl:template>

  <xsl:template match="d:u">
    <u>
      <xsl:apply-templates/>
    </u>
  </xsl:template>

  <xsl:template match="d:i">
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="d:c">
    <span class="code">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="d:pre">
    <pre>
      <xsl:apply-templates/>
    </pre>
  </xsl:template>

  <xsl:template match="d:img">
    <img>
      <xsl:attribute name="src">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </img>
  </xsl:template>

  <xsl:template match="d:hl">
    <h3>
      <xsl:value-of select="."/>
    </h3>
  </xsl:template>

  <xsl:template match="d:br">
    <br/>
  </xsl:template>

  <xsl:template match="d:link">
    <a>
      <xsl:attribute name="href">
        <xsl:value-of select="@href"/>
      </xsl:attribute>
      <xsl:apply-templates />
    </a>
  </xsl:template>

  <xsl:template match="d:xhtml">
    <xsl:copy-of select="node()"/>
  </xsl:template>

</xsl:stylesheet>
