﻿## Get-GenericType.ps1
## Creates a closed generic type:
##
## Usage:
##
##   # Simple generic collection
##   Get-GenericType System.Collections.ObjectModel.Collection System.Int32
##
##   # Generic dictionary with two types
##   Get-GenericType System.Collections.Generic.Dictionary System.String,System.Int32
##
##   # Generic list as the second type to a generic dictionary
##   $secondType = Get-GenericType System.Collections.Generic.List Int32
##   Get-GenericType System.Collections.Generic.Dictionary System.String,$secondType
##

param(
    [string] $typeName = $(throw "Please specify a generic type name"),
    [string[]] $typeParameters = $(throw "Please specify the type parameters")
)

## Create the generic type name
$genericTypeName = $typeName + '`' + $typeParameters.Count
$genericType = [Type] $genericTypeName

if(-not $genericType)
{
    throw "Could not find generic type $genericTypeName"
}

## Bind the type arguments to it
[Type[]] $typedParameters = $typeParameters
$closedType = $genericType.MakeGenericType($typedParameters)
if(-not $closedType)
{
    throw "Could not make closed type $genericType"
}

,$closedType