#=========================================================#
# Boot-Script                                             #
#=========================================================#

# Configuration-Provider starten
New-PSDrive -PSProvider DNConfiguration -Name dncfg -Root \ -Configuration $runtime.Configuration | Out-Null

# Runtime-Provider starten
New-PSDrive -PSProvider DNRuntime -Name dn -Root \ -Runtime $runtime | Out-Null

# Script-Pfade zur Umgebungsvariable hinzufgen
${env:PATH} = "${env:PATH};${dncfg:ScriptsPath}"
if (${dncfg:HasWorkspace}) {
	${env:PATH} = "${env:PATH};${dncfg:WorkspacePath}\scripts"
}

# Standardbibliothek laden
. lib.ps1

# In den Pfad des DynamicNodes-Providers wechseln
Set-Location dn:\Runtime

# Die Shell bei NLibShell registrieren
$shell = Get-Asset $([de.mastersign.shell.GraphicalShell])
[DynamicNode.Ext.Shell.ShellRegistry]::Shell = $shell

""
"DynamicNodes Core Shell"
"-----------------------"
"Der Befehl 'dnhelp' zeigt eine Befehlsliste an."