﻿
var runtimeId = 0;
var graphId = 0;

function initCockpit(rId, gId) {
    runtimeId = rId;
    graphId = gId;
}

function loadCockpit() {
    $.get(
        gPath(runtimeId, graphId) + "cockpit/root.html",
        function (cockpit) {
            $("#cockpit").empty().append(cockpit);
        });
}

function cPath(cId) {
    return gPath(runtimeId, graphId) + "cockpit/control/" + cId + "/";
}

function triggerControlTrigger(cId) {
    var url = cPath(cId) + "trigger";
    $.get(
        url,
        function () {
            // TODO Reaktion auf Erfolg/Fehler
        });
}

function booleanControlUpdate(cId) {
    var url = cPath(cId) + "update";
    var value = $("#" + cId + "_input").attr('checked') ? "true" : "false";
    $.post(
        url,
        { checked: value },
        function () {
            // TODO Reaktion auf Erfolg/Fehler
        });
}

function stringControlUpdate(cId) {
    var url = cPath(cId) + "update";
    var value = $("#" + cId + "_input").val();
    $.post(
        url,
        { newValue: value },
        function () {
            // TODO Reaktion auf Erfolg/Fehler
        });
}

function numericControlSlide(cId) {
    var value = $("#" + cId + "_input").slider("value");
    var f = $("#" + cId + "_display").attr("x-dn:f");
    value = value / f;
    $("#" + cId + "_display").empty().append(value);
}

function numericControlUpdate(cId) {
    numericControlSlide(cId);
    var value = $("#" + cId + "_input").slider("value");
    var url = cPath(cId) + "update";
    $.post(
        url,
        { newValue: value },
        function () {
            // TODO Reaktion auf Erfolg/Fehler
        });
}

var displayRefreshList = [];
var displayAutoToggleList = [];

function registerDisplayControl(refreshFunc, cId) {
    displayRefreshList[cId] = refreshFunc;
}

function displayControlRefresh(cId) {
    displayRefreshList[cId](cId);
}

function refreshAllDisplays() {
    for (var cId in displayRefreshList) {
        displayRefreshList[cId](cId);
    }
}

function displayControlToggleAutoRefresh(cId) {
    if ($("#" + cId + "_autorefresh").attr("checked")) {
        displayControlActivateAutoRefresh(cId);
    } else {
        displayControlDeactivateAutoRefresh(cId);
    }
}

function displayControlActivateAutoRefresh(cId) {
    var time = $("#" + cId + "_refreshtime").spinner("value") * 1000.0;
    displayAutoToggleList[cId] = window.setInterval(
        function () { displayControlRefresh(cId); }, time);
}

function displayControlDeactivateAutoRefresh(cId) {
    window.clearInterval(displayAutoToggleList[cId]);
    displayAutoToggleList[cId] = null;
}

function displayControlChangeRefreshTime(cId) {
    if ($("#" + cId + "_autorefresh").attr("checked")) {
        displayControlDeactivateAutoRefresh(cId);
        displayControlActivateAutoRefresh(cId);
    }
}

function imageDisplayControlRefresh(cId) {
    var cPrev = $("#" + cId + "_preview");
    cPrev.attr("src", cPath(cId) + "preview.jpg#" + $.now());
}

function textDisplayControlRefresh(cId) {
    var url = cPath(cId) + "text";
    $.get(
        url,
        function(text) {
            var cDisp = $("#" + cId + "_display");
            cDisp.empty().append(text);
        }
    );
}