using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.Drawing;

namespace DynamicNode.Examples
{
    public partial class Animation : Control
    {
        Timer timer = new Timer();

        public Animation()
        {
            InitializeComponent();
            timer.Interval = 50;
            timer.Enabled = false;
            timer.Tick += new EventHandler(timer_Tick);
            SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            SetStyle(ControlStyles.Opaque, true);
        }

        void timer_Tick(object sender, EventArgs e)
        {
            this.Refresh();
        }

        public Animation(IContainer container)
        {
            container.Add(this);

            InitializeComponent();
        }

        public bool AnimationEnabled
        {
            get { return timer.Enabled; }
            set { timer.Enabled = value; }
        }

        protected override void OnPaintBackground(PaintEventArgs pevent)
        {
            // nichts
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            BufferedGraphics bg = BufferedGraphicsManager.Current.Allocate(e.Graphics, ClientRectangle);

            LinearGradientBrush b = new LinearGradientBrush(
                ClientRectangle, Color.Black, Color.White,
                (float)((double)DateTime.Now.Millisecond * 0.36));
            bg.Graphics.FillRectangle(b, ClientRectangle);
            b.Dispose();

            bg.Render();
            bg.Dispose();
        }
    }
}
