using System;
using DynamicNode.Core;
using DynamicNode.Lib.Tutorial.Properties;

namespace DynamicNode.Lib.Tutorial
{
    [StaticNodeInfo(typeof(NSample), "GetNodeInfo")]
    public class NSample : Node
    {
        public static NodeInfoAttribute GetNodeInfo()
        {
            return new NodeInfoAttribute(
                Resources.NSample_Caption,
                Resources.Group_Math,
                Resources.NSample_Description);
        }

        [InPortInfo("a", "Faktor A")]
        public double factor_a = 0.0;

        [InPortInfo("b", "Faktor B")]
        public double factor_b = 0.0;

        [OutPortInfo("p", "Produkt", typeof(double))]
        public OutPortHandler product;

        public override void Work()
        {
            product(new Token(factor_a * factor_b));
        }
    }
}
